﻿using F165300_Core.Models;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Syncfusion.PresentationRenderer;
using Syncfusion.Presentation;
using Syncfusion.OfficeChart;
using System.IO;
using Syncfusion.XlsIORenderer;
using Syncfusion.XlsIO;

namespace F165300_Core.Controllers
{
    public class HomeController : Controller
    {
        public IActionResult Index()
        {
            return View();
        }
        public IActionResult CreatePPT()
        {
            IPresentation pptxDoc = Presentation.Create();
            // Create an instance of Presentation Renderer for converting chart to image 
            pptxDoc.PresentationRenderer = new PresentationRenderer();
            //Adds a blank slide to the Presentation 
            ISlide slide = pptxDoc.Slides.Add(SlideLayoutType.Blank);
            //Adds chart to the slide with position and size 
            IPresentationChart chart = slide.Charts.AddChart(100, 10, 700, 500);
            //Specifies the chart title 
            chart.ChartTitle = "Sales Analysis";
            //Specifies the chart type 
            chart.ChartType = OfficeChartType.Column_Clustered;
            //Sets chart data - Row1 
            chart.ChartData.SetValue(1, 2, "Jan");
            chart.ChartData.SetValue(1, 3, "Feb");
            //Sets chart data - Row2 
            chart.ChartData.SetValue(2, 1, 2010);
            chart.ChartData.SetValue(2, 2, 900);
            chart.ChartData.SetValue(2, 3, 800);
            //Sets chart data - Row3 
            chart.ChartData.SetValue(3, 1, 2011);
            chart.ChartData.SetValue(3, 2, 800);
            chart.ChartData.SetValue(3, 3, 700);
            //Sets chart data - Row4 
            chart.ChartData.SetValue(4, 1, 2012);
            chart.ChartData.SetValue(4, 2, 700);
            chart.ChartData.SetValue(4, 3, 600);
            //Sets the data range of the category axis 
            chart.PrimaryCategoryAxis.CategoryLabels = chart.ChartData[2, 1, 4, 1];
            //Creates a new chart series with the name 
            IOfficeChartSerie seriesJan = chart.Series.Add("Jan");
            //Sets the data range of chart series – start row, start column, end row, end column 
            seriesJan.Values = chart.ChartData[2, 2, 4, 2];
            //Creates a new chart series with the name 
            IOfficeChartSerie seriesFeb = chart.Series.Add("Feb");
            //Sets the data range of chart series – start row, start column, end row, end column 
            seriesFeb.Values = chart.ChartData[2, 3, 4, 3];
            //Set the primary axis for the serie
            seriesFeb.UsePrimaryAxis = true;
            seriesFeb.SerieFormat.CommonSerieOptions.Overlap = 40;
            seriesFeb.SerieFormat.CommonSerieOptions.GapWidth = 50;
            using (var stream = new MemoryStream())
            {
                pptxDoc.PresentationRenderer.ConvertToImage(chart, stream);
                slide.Shapes.AddPicture(stream, 100, 10, 700, 500);
            }
            FileStream outputStream = new FileStream("PPT_ChartToImage.pptx", FileMode.Create, FileAccess.ReadWrite, FileShare.ReadWrite);
            pptxDoc.Save(outputStream);
            pptxDoc.Close();
            outputStream.Flush();
            outputStream.Dispose();

            return View("Index");
        }
        public IActionResult CreateExcel()
        {
            using(ExcelEngine excelEngine = new ExcelEngine())
            {
                IApplication application = excelEngine.Excel;
                application.DefaultVersion = ExcelVersion.Excel2016;
                IWorkbook workbook = application.Workbooks.Create(1);
                IWorksheet worksheet = workbook.Worksheets[0];

                IChart chart = worksheet.Charts.Add();
                chart.ChartType = ExcelChartType.Column_Clustered;

                worksheet.Range["A2"].Value = "2010";
                worksheet.Range["A3"].Value = "2011";
                worksheet.Range["A4"].Value = "2012";

                worksheet.Range["B1"].Value = "Jan";
                worksheet.Range["C1"].Value = "Feb";

                worksheet.Range["B2"].Value = "900";
                worksheet.Range["B3"].Value = "800";
                worksheet.Range["B4"].Value = "700";

                worksheet.Range["C2"].Value = "800";
                worksheet.Range["C3"].Value = "700";
                worksheet.Range["C4"].Value = "600";               

                chart.PrimaryCategoryAxis.CategoryLabels = worksheet.Range["A2:A4"];
                //Creates a new chart series with the name 
                IChartSerie seriesJan = chart.Series.Add("Jan");
                //Sets the data range of chart series – start row, start column, end row, end column 
                seriesJan.Values = worksheet.Range["B2:B4"];
                //Creates a new chart series with the name 
                IChartSerie seriesFeb = chart.Series.Add("Feb");
                //Sets the data range of chart series – start row, start column, end row, end column 
                seriesFeb.Values = worksheet.Range["C2:C4"];
                //Set the primary axis for the serie
                seriesFeb.UsePrimaryAxis = true;
                seriesFeb.SerieFormat.CommonSerieOptions.Overlap = 40;
                seriesFeb.SerieFormat.CommonSerieOptions.GapWidth = 50;

                application.XlsIORenderer = new XlsIORenderer();
                application.XlsIORenderer.ChartRenderingOptions.ImageFormat = Syncfusion.XlsIO.ExportImageFormat.Png;
                MemoryStream imageStream = new MemoryStream();
                chart.SaveAsImage(imageStream);

                IPictureShape shape = worksheet.Pictures.AddPicture(10, 10, imageStream, 20,20);

                //Saving the workbook as stream
                FileStream stream = new FileStream("Excel_ChartIoImage.xlsx", FileMode.Create, FileAccess.ReadWrite);
                workbook.SaveAs(stream);
                stream.Dispose();

                return View("Index");
            }
        }

        public IActionResult About()
        {
            ViewData["Message"] = "Your application description page.";

            return View();
        }

        public IActionResult Contact()
        {
            ViewData["Message"] = "Your contact page.";

            return View();
        }

        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
